// Module Name
module nsmsgs.types;

// private import
private import win32.windows;

// Basic Types
alias HANDLE HNsmService;
alias HANDLE HNsmEvent;
alias HANDLE HNsmConnection;
alias HANDLE HNsmSession;

// Functions
extern(Windows) {
	alias int function(WPARAM wParam, LPARAM lParam) TNsmServiceProc;
	alias int function(WPARAM wParam, LPARAM lParam) TNsmEventProc;
	// basic callback functions
	alias HNsmService function(LPCSTR lpServiceName, TNsmServiceProc lpProcAddr)         TCreateServiceProc;
	alias HNsmService function(LPCSTR lpServiceName)                                     TGetServiceProc;
	alias int         function(HNsmService hServiceHandle, WPARAM wParam, LPARAM lParam) TCallServiceProc;
	alias HNsmEvent   function(LPCSTR lpEventName)                                       TCreateEventProc;
	alias HNsmEvent   function(LPCSTR lpEventName)                                       TGetEventProc;
	alias int         function(HNsmEvent hEventHandle, WPARAM wParam, LPARAM lParam)     TNotifyEventProc;
	alias int         function(LPCSTR lpEventName, TNsmEventProc lpProcAddr)             THookEventProc;
	alias int         function(LPCSTR lpEventName, TNsmEventProc lpProcAddr)             TUnhookEventProc;
	// other callback functions
	alias int  function(HNsmConnection hConnection, int nData) TEnumConnectionCallback;
	alias int  function(HNsmSession hSession, int nData)       TEnumSessionCallback;
	alias int  function(LPTSTR lpProtocol, int nData)          TEnumProtocolCallback;
	alias int  function(LPTSTR lpModuleName, int nData)        TEnumModuleCallback;
	alias int  function(LPTSTR lpAccount, int nData)           TEnumMemberCallback;
	alias int  function(int nGroupID, int nData)               TEnumGroupCallback;
	alias int  function(LPTSTR lpServiceName, int nData)       TEnumUIServiceCallback;
	alias void function(int nData)                             TNotifyClickCallback;
}

// Structures
align(8) {
	struct TNsmPluginInitInfo {
		int                cbSize;
		TCreateServiceProc CreateService;
		TGetServiceProc    GetService;
		TCallServiceProc   CallService;
		TCreateEventProc   CreateEvent;
		TGetEventProc      GetEvent;
		TNotifyEventProc   NotifyEvent;
		THookEventProc     HookEvent;
		TUnhookEventProc   UnhookEvent;
	};
	alias TNsmPluginInitInfo* PNsmPluginInitInfo;
	
	struct TLogInInfo {
		int     cbSize;
		LPCSTR lpAccount;
		LPCSTR lpPassword;
		int     nStatus;
		LPCWSTR lpCaption;
	};
	alias TLogInInfo* PLogInInfo;
	
	struct TEnumMemberInfo {
		int cbSize;                         // \̂̃TCY
		int nListKind;                      // R^NgXg̎
		int nFlags;                         // \
		TEnumMemberCallback lpCallBackProc; // R[obN֐
		int nData;                          // R[obN֐ɓnCӃf[^
	};
	alias TEnumMemberInfo* PEnumMemberInfo;
	
	struct TEnumGroupInfo {
		int cbSize;                         // \̂̃TCY
		int nFlags;                         // \
		TEnumGroupCallback lpCallBackProc;  // R[obN֐
		int nData;                          // R[obN֐ɓnCӃf[^
	};
	alias TEnumGroupInfo* PEnumGroupInfo;
	
	struct TNsmInfo {
		int nType;                          // ̌^
		LPBYTE lpBuffer;                    // i[obt@
		int nBufferSize;                    // obt@̃TCY
	};
	alias TNsmInfo* PNsmInfo;
	
	struct TNsmMemberInfo {
		int cbSize;                         // \̂̃TCY
		int nListKind;                      // R^NgXg̎  	
		LPCSTR lpAccount;                   // ݒ|擾õAJEg
		int nInfoKey;                       // 擾̃L[
		PNsmInfo lpInfo;                    // i[\̂ւ̃|C^
		int nFlags;                         // \
	};
	alias TNsmMemberInfo* PNsmMemberInfo;
	
	struct TNsmGroupInfo {
		int cbSize;                         // \̂̃TCY
		int nGroupID;                       // ݒ|擾O[vID
		int nInfoKey;                       // 擾̃L[
		PNsmInfo lpInfo;                    // i[\̂ւ̃|C^
		int nFlags;                         // \
	};
	alias TNsmGroupInfo* PNsmGroupInfo;
	
	struct TAddMemberInfo {
		int cbSize;                         // \̂̃TCY
		int nListKind;                      // R^NgXg̎  	
		LPCSTR lpAccount;                   // ݒ|擾õAJEg
	};
	alias TAddMemberInfo* PAddMemberInfo;
	alias TAddMemberInfo  TRemoveMemberInfo;
	alias TAddMemberInfo* PRemoveMemberInfo;
	
	struct TNsmConnectionInfo {
		int cbSize;                         // \̂̃TCY
		int nInfoKey;                       // 擾̃L[
		PNsmInfo lpInfo;                    // i[\̂ւ̃|C^
	};
	alias TNsmConnectionInfo* PNsmConnectionInfo;
	
	struct TNsmSessionInfo {
		int cbSize;                         // \̂̃TCY
		int nInfoKey;                       // 擾̃L[
		PNsmInfo lpInfo;                    // i[\̂ւ̃|C^
	};
	alias TNsmSessionInfo* PNsmSessionInfo;
	
	struct TMessageBoxInfo {
		int cbSize;                         // \̂̃TCY
		HWND hWnd;                          // eEBhẼnhi0 ̏ꍇ͎ݒj
		LPCWSTR lpText;                     //
		LPCWSTR lpCaption;                  //
		DWORD uType;                        //
	};
	alias TMessageBoxInfo* PMessageBoxInfo;
	
	struct TNotifyInfo {
		int cbSize;                         // \̂̃TCY
		LPCWSTR lpText;                     // \镶
		int nTimeToLive;                    // L\ԁibA0=ƕ\A-1=ftHglj
		int nIcon;                          // \ACR̎
		LPCWSTR lpLinkTo;                   // NbNƂɊJURL
		TNotifyClickCallback lpOnClick;     // NbNƂɌĂ΂R[obN֐
		int nData;                          // R[obN֐ɓnCӃf[^
	};
	alias TNotifyInfo* PNotifyInfo;
	
	struct TOpenSessionInfo {
		int cbSize;                         // \̂̃TCY
		LPCSTR lpToAccount;                 // 
	};
	alias TOpenSessionInfo* POpenSessionInfo;
	
	struct TTextAttributeInfo {
		int cbSize;                         // \̂̃TCY
		LPCWSTR lpFontName;                 // tHg
		int nCharSet;                       // LN^ZbgiShiftJIS = 128j
		int nFontSize;                      // TCYi|Cgj
		int nFontColor;                     // F
		int nBgColor;                       // wiF
		int nStyles;                        // tOiBold, Italic, etc...j
	};
	alias TTextAttributeInfo* PTextAttributeInfo;
	
	struct TMessageInfo {
		int cbSize;                         // \̂̃TCY
		LPCSTR lpFrom;                      // olAJEgiM̏ꍇ NULL łj
		LPCWSTR lpBody;                     // bZ[W̖{iUNICODEj
		PTextAttributeInfo lpTextAttribute; // 
		int nFlags;                         // \
	};
	alias TMessageInfo* PMessageInfo;
	
	struct TUserStatusInfo {
		int cbSize;                         // \̂̃TCY
		int nStatus;                        // 
		LPCWSTR lpStatusStr;                // Ԃ\iNMST_CUSTOM ̎̂ݗLj
		int nBusyness;                      // ZiNMST_CUSTOM ̎̂ݗLj
	};
	alias TUserStatusInfo* PUserStatusInfo;
	
	struct TUserNameInfo {
		int cbSize;                         // \̂̃TCY
		LPCWSTR lpName;                     // VO
	};
	alias TUserNameInfo* PUserNameInfo;
	
	struct TGroupNameInfo {
		int cbSize;                         // \̂̃TCY
		int nGroupId;                       // ΏۃO[vID
		LPCWSTR lpName;                     // VO[v
	};
	alias TGroupNameInfo* PGroupNameInfo;
	
	struct TMemberGroupInfo {
		int cbSize;                         // \̂̃TCY
		LPCSTR lpAccount;                   // ΏۃoAJEg
		int nGroupId;                       // VO[vID
	};
	alias TMemberGroupInfo* PMemberGroupInfo;
	
	struct TEnumUIServiceInfo {
		int cbSize;                        // \̂̃TCY
		TEnumUIServiceCallback lpCallBackProc; // R[obN֐ւ̃|C^
		int nData;                         // R[obN֐ɓnf[^
		int nFlags;                        // \
	};
	alias TEnumUIServiceInfo* PEnumUIServiceInfo;
	
	struct TNsmUIServiceInfo {
		int cbSize;                        // \̂̃TCY
		int nInfoKey;                      // UIT[rXĂяoR(NMUI_XXXXŎw)
		int nGroupId;                      // O[vID
		LPCSTR lpAccount;                  // AJEg
		PNsmInfo lpInfo;                   // ݒp
		int nFlags;                        // \
	};
	alias TNsmUIServiceInfo* PNsmUIServiceInfo;
	
	struct TNsmFileIOData {
		int cbSize;                        // \̂̃TCY
		int nDataLen;                      // obt@TCY
		LPBYTE lpData;                     // f[^ǂݍރobt@
	};
	alias TNsmFileIOData* PNsmFileIOData;
	
	struct TNsmFileIOInfo {
		int cbSize;                        // \̂̃TCY
		int nFileSize;                     // t@CTCY
	};
	alias TNsmFileIOInfo* PNsmFileIOInfo;
	
	struct TNsmStrRsc {
		int cbSize;                        // \̂̃TCY
		LPCTSTR lpPluginName;               // vOC
		LPCTSTR lpSectionName;              // ZNV
		LPCTSTR lpMessageTag;               // ^O
		LPCTSTR lpDefaultStr;               // ftHg
		int nBufferSize;                   // obt@TCY
		LPBYTE lpBuffer;                   // obt@
	};
	alias TNsmStrRsc* PNsmStrRsc;
}

// Export
extern (C) {
	extern (Windows) int GetPluginInfo(int nInfoNo, LPTSTR lpBuffer, int nSize);
	extern (Windows) int Initialize(PNsmPluginInitInfo lpInitInfo);
	extern (Windows) int Terminate();
}
