﻿/*
	Kabegami plugin for Regnessem
	Copyright (c) 2004 Sapphire. All rights Reserved.
*/

module Kabegami;

private {
  import win32.ansi.windows;
  import nsmsgs.consts, nsmsgs.types, wstring;
  import std.string, std.thread, std.stream;
  import std.date, std.random, std.utf, std.path;
}

const char[] MODULENAME = "Kabegami";

extern (C) {
  void gc_init();
  void gc_term();
  void _minit();
  void _moduleCtor();
  void _moduleUnitTests();
}

private {
  const char[][] PluginInfo = [
    NSM_API_VERSION,
    "AddIn/"~MODULENAME,
    "Kabegami",
    "WallPaper Changer for Regnessem",
    "Sapphire",
    "Copyright (c) 2004 Sapphire",
    "0.0.3",
  ];
	TNsmPluginInitInfo g_InitInfo;
	HINSTANCE g_hInstance;
	char[][] files;
	UpdateThread ut;
}

extern (Windows)
BOOL DllMain(HINSTANCE hInstance, ULONG ulReason, LPVOID pvReserved)
{
  switch (ulReason) {
  case DLL_PROCESS_ATTACH:
    gc_init();          // init GC
		_minit();           // init module list
		_moduleCtor();      // run  module constructor
		_moduleUnitTests(); // run  unit test
		break;
	case DLL_PROCESS_DETACH:
		gc_term();
		break;
	case DLL_THREAD_ATTACH:
	case DLL_THREAD_DETACH:
		// multi-thread is not supported
		return FALSE;
	}
  
  g_hInstance = hInstance;
  
	return TRUE;
}

extern (Windows)
int GetPluginInfo(int nInfoNo, LPTSTR lpBuffer, int nSize)
{
	if (nInfoNo < 0 || nInfoNo > PluginInfo.length) {
		return 0;
	} else {
		lstrcpyn(lpBuffer, toStringz(PluginInfo[nInfoNo]), nSize);
		return lstrlen(lpBuffer);
	}
}

extern (Windows)
int Initialize(PNsmPluginInitInfo lpInitInfo)
{
  g_InitInfo = *lpInitInfo;
  createAllServices();

	wchar[] buffer = new wchar[MAX_PATH];
	int len = GetModuleFileNameW(NULL, buffer, MAX_PATH -1);
	wchar[] filename = toUTF16(getDirName(toUTF8(buffer[0..len]))~"\\Plugins\\Kabegami\\files.dat");
  
	File f = new File(toUTF8(filename));
	char[] tmp;
	
	// ファイル解析
	for(int i=0; ; ) {
		tmp=f.readLine();
		if(!cmp(tmp,"")) break;
		
		if(isdir(tmp)) {	// ディレクトリなら中を解析
			char[][] list=listdir(tmp);
			foreach(char[] file; list) {
				if(!cmp("bmp", tolower(getExt(file)))) {  // BMPファイルなら
					files.length=i+1;
					files[i]=getDirName(tmp)~"\\"~file;
					i++;
				}
			}
		} else {	// ファイル
			files.length=i+1;
			files[i]=tmp;
			i++;
		}
	}
	f.close();

  ut = new UpdateThread();
  ut.start();

  return 0;
}

extern (Windows)
int Terminate()
{
	ut.flag=true;
	
	return 0;
}

extern(Windows)
int Common_ShowOptionDialog(WPARAM wParam, LPARAM lParam) {
	return 0;
}

extern(Windows)
void createAllServices() {
	char buf[];
	
	// 共通サービスの作成
	buf = format(NMS_COMMON_SHOWOPTIONDIALOG, "AddIn/"~MODULENAME);
	g_InitInfo.CreateService(toStringz(buf), &Common_ShowOptionDialog);
}

class UpdateThread : Thread
{
		bool flag=false;

  int run() {
	  int count=0, interval;
	  int prev=-1, num=-1;
		int used_count=0;

	wchar[] buffer = new wchar[MAX_PATH];
	int len = GetModuleFileNameW(NULL, buffer, MAX_PATH -1);
	wchar[] inifile = toUTF16(getDirName(toUTF8(buffer[0..len]))~"\\Plugins\\Kabegami\\Kabegami.ini");

	  rand_seed(getUTCtime(), 0);
		interval = GetPrivateProfileIntW(toWStringz("global"), toWStringz("interval"), 60, toWStringz(inifile));

	  bit used[];
	  used.length=files.length;

		do {
			if(files.length==0) break;
			
			if (count==(interval*2*60)) {
				if(used_count==files.length) {
					used_count=0;
					for(int i=0; i<used.length; i++) used[i]=false;
				}
				
				if(files.length==1) num=1;
				else num=rand()%files.length;
				
				for(;used[num];) {
					num++;
					if(num==used.length) num=0;
				}
				
				used_count++;
				used[num]=true;
				
				char[] file = files[num];
				// 壁紙の変更
				SystemParametersInfo(SPI_SETDESKWALLPAPER,
					0,
					toStringz(file),
					SPIF_UPDATEINIFILE
				);
        count = 0;
      }
      Sleep(500);
      count++;
   	}while(!flag);
	  return 0;
	}
}
